//graphics.c
//Shows 3 different graphics techniques.
//1) "Old" sprite method (use sprite function instead, see sprite.c)
//2) Double-Buffered Screens
//3) Triple-Buffered Screens (slowest, but smoothest)
//Note: Different techniques are better for different
//screen depths.  The higher the screen depth, the slower
//buffered techiques are.  Sprite techiques fair better
//under higher screen depths. 

library "PToolboxLib"

int t;
int x_move[3], y_move[3];
int x_pos[3], y_pos[3];

start() { t=ticks(); }
stop(string a) { puts(a+": "+(ticks()-t)+"\n"); }

setup() {

  //Setup positions
  x_pos[0] = 10;
  y_pos[0] = 10;  
  x_pos[1] = 120;
  y_pos[1] = 40;
  x_pos[2] = 40;
  y_pos[2] = 120;
  
  //Setup Movement
  x_move[0] = -1;
  y_move[0] = -1;
  x_move[1] = 1;
  y_move[1] = -1;  
  x_move[2] = 1;
  y_move[2] = 1;
}

main() {

int i,j;

if(!OpenBmpDb("test_bitmap")) {
  alert("Failed to find test_bitmap.prc!");
  return;
}
SetDepth(8);
graph_on();

//Setup buffers
SetDrawBuf(1);
SetDrawBuf(2);
ClearBuf();
line(1,0,40,160,40);
line(1,0,120,160,120);
line(1,40,0,40,160);
line(1,120,0,120,160);
SetDrawBuf(0);

CustomBuf(3,16,16);
CustomBuf(4,16,16);
CustomBuf(5,16,16);

CopyBuf(0,2);

setup();

//"Old" sprite technique (use sprite function instead)

for(i=0;i<3;i++) {
  CopyRect(0,0,0,x_pos[i],y_pos[i],16,16,0,3+i,-1);
}

start();
i=200;
while(i--) {

  //Restore
  CopyRect(3,x_pos[0],y_pos[0],0,0,16,16,0,0,-1);
  CopyRect(4,x_pos[1],y_pos[1],0,0,16,16,0,0,-1);
  CopyRect(5,x_pos[2],y_pos[2],0,0,16,16,0,0,-1);

  //Re-Calc Positions
  j=3;
  while(j--) {
    x_pos[j] = x_pos[j] + x_move[j];
    if(x_pos[j]<0 || x_pos[j]>144) {
      x_move[j] = x_move[j] * -1;
      x_pos[j] = x_pos[j] + x_move[j];
    }
    y_pos[j] = y_pos[j] + y_move[j];
    if(y_pos[j]<0 || y_pos[j]>144) {
      y_move[j] = y_move[j] * -1;
      y_pos[j] = y_pos[j] + y_move[j];
    } 
  }
  
  //Save Background
  CopyRect(0,0,0,x_pos[0],y_pos[0],16,16,0,3,-1);
  CopyRect(0,0,0,x_pos[1],y_pos[1],16,16,0,4,-1);
  CopyRect(0,0,0,x_pos[2],y_pos[2],16,16,0,5,-1);
  
  //Draw
  TransBmp(x_pos[0],y_pos[0],5,5);
  TransBmp(x_pos[1],y_pos[1],5,5);
  TransBmp(x_pos[2],y_pos[2],5,5);
}
stop("Old Sprite");

// Doubled-Buffered Screens

start();
i=200;
while(i--) {

  //Re-Calc Positions
  j=3;
  while(j--) {
    x_pos[j] = x_pos[j] + x_move[j];
    if(x_pos[j]<0 || x_pos[j]>144) {
      x_move[j] = x_move[j] * -1;
      x_pos[j] = x_pos[j] + x_move[j];
    }
    y_pos[j] = y_pos[j] + y_move[j];
    if(y_pos[j]<0 || y_pos[j]>144) {
      y_move[j] = y_move[j] * -1;
      y_pos[j] = y_pos[j] + y_move[j];
    } 
  }

  //Copy background to main display
  CopyBuf(0,2);
  
  //Draw
  TransBmp(x_pos[0],y_pos[0],5,5);
  TransBmp(x_pos[1],y_pos[1],5,5);
  TransBmp(x_pos[2],y_pos[2],5,5); 
}
stop("Double Buffered");

SetDrawBuf(1);
ClearBuf();

// Triple-Buffered Screens (smoothest, but slowest)

start();
i=200;
while(i--) {

  //Re-Calc Positions
  j=3;
  while(j--) {
    x_pos[j] = x_pos[j] + x_move[j];
    if(x_pos[j]<0 || x_pos[j]>144) {
      x_move[j] = x_move[j] * -1;
      x_pos[j] = x_pos[j] + x_move[j];
    }
    y_pos[j] = y_pos[j] + y_move[j];
    if(y_pos[j]<0 || y_pos[j]>144) {
      y_move[j] = y_move[j] * -1;
      y_pos[j] = y_pos[j] + y_move[j];
    } 
  }

  //Copy background to main display
  CopyBuf(1,2);
  
  //Draw
  TransBmp(x_pos[0],y_pos[0],5,5);
  TransBmp(x_pos[1],y_pos[1],5,5);
  TransBmp(x_pos[2],y_pos[2],5,5);
  
  CopyBuf(0,1); 
}
stop("Triple Buffered");

event(1);
graph_off();
SetDepth(0);
}